//
//  MCMAccount.h
//  MCServerSupport
//
//  Created by Brent Gulanowski on 09-10-22.
//  Copyright 2009 Marketcircle Inc. All rights reserved.
//

#import <CoreData/CoreData.h>

@class MCMMessage;

@interface MCMAccount : NSManagedObject {

	id target;
}

- (NSNumber *)dispatched;
- (void)setDispatched:(NSNumber *)value;
//- (BOOL)validateDispatched:(id *)valueRef error:(NSError **)outError;

- (NSString *)key;
- (void)setKey:(NSString *)value;
//- (BOOL)validateKey:(id *)valueRef error:(NSError **)outError;

- (NSString *)name;
- (void)setName:(NSString *)value;
//- (BOOL)validateName:(id *)valueRef error:(NSError **)outError;

// Access to-many relationship via -[NSObject mutableSetValueForKey:]
- (void)addReceivedMessagesObject:(MCMMessage *)value;
- (void)removeReceivedMessagesObject:(MCMMessage *)value;

// Access to-many relationship via -[NSObject mutableSetValueForKey:]
- (void)addSentMessagesObject:(MCMMessage *)value;
- (void)removeSentMessagesObject:(MCMMessage *)value;

- (id)target;
- (void)setTarget:(id)aTarget;

+ (MCMAccount *)accountWithName:(NSString *)name inContext:(NSManagedObjectContext *)context create:(BOOL)create;
+ (MCMAccount *)accountWithName:(NSString *)name create:(BOOL)create;

// Only attachments/arguments supported by the NSCoding protocol are valid
- (MCMMessage *)sendMessageTo:(NSString *)receiver subject:(NSString *)subject body:(NSString *)body;
- (MCMMessage *)sendMessageTo:(NSString *)receiver subject:(NSString *)subject body:(NSString *)body attachments:(NSArray *)attachments;

// If the receiver's account does not support dispatch, this won't send anything
- (MCMMessage *)sendDispatchTo:(NSString *)receiver selector:(SEL)selector arguments:(NSArray *)arguments;

// messages to me from specified sender
- (NSArray *)messagesFrom:(NSString *)sender;
- (NSArray *)unreadMessagesFrom:(NSString *)sender;

- (BOOL)overLimit;

- (NSString *)senderNameForDispatches;

- (void)dispatchNewMessages;
- (NSArray *)pendingMessagesFor:(NSString *)receiver subject:(NSString *)subject;

- (void)deleteOldMessagesBeforeDate:(NSDate *)cutoff;

@end

@interface NSObject (MCMDispatchAutomaticSupport)

// return an array of selector names acceptable to be used with -dispatchNewMessages
// any dispatch message whose subject (selector name) is not in the returned array is ignored
- (NSArray *)safeMessages;

@end

